---
title: Billing policy · Cloudflare Billing docs
description: The terms subscription and add-on service are used interchangeably
  in this support guide.
lastUpdated: 2025-08-11T20:52:41.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/billing/billing-policy/
  md: https://developers.cloudflare.com/billing/billing-policy/index.md
---

**The terms subscription and add-on service are used interchangeably in this support guide.**

Cloudflare plans and add-on services are billed every 30 days for each domain in your account.

Cloudflare plans are billed monthly and annually for each domain on the account. Monthly plans are billed every 30 days for each domain in your account, and annual plans are billed yearly for each domain in your account.

Add-on services are only billed monthly and cannot be billed annually.

Cloudflare also collects sales tax as governed by local laws. Sales taxes are computed based on the nine (9) digit postal code of either the shipping or billing address on file for your Cloudflare account where applicable.

Note

If you are a US-based customer, you can [file for sales tax exemption](https://developers.cloudflare.com/billing/sales-tax/#filing-for-us-sales-tax-exemption/).

Cloudflare issues a separate invoice for plans and subscriptions (or add-on services) for every domain added to a Cloudflare account.

Cloudflare issues a monthly or annual invoice based on the plans you purchase. You will receive a $0 invoice even if your domain is on a Free plan.

Note

Subdomains do not count as billable domains.

For example, if test1.com and test2.com are added to the same Cloudflare account and upgraded to the Pro plan, you will receive an invoice with two charges. Subdomains such as blog.test1.com or blog.test2.com will not be included as billable domains.

The date you initiate a paid plan or add-on service will be both the start of your billing period and your [invoice date](https://developers.cloudflare.com/billing/invoices/). For example, if you upgrade your plan on January 10, all future plan charges will be billed on the 10th of every month. Both dates are initialized using the UTC (Coordinated Universal Time) time zone, and not your local time zone.

If your account is dunned (downgraded and banned for non payment of dues), the new start date changes to the day of the upgrade and applies to monthly, yearly, and add-on plans.

When ordering a paid plan, subscription, or add-on service, you must agree to the following:

*By clicking "Enable" you agree that you are purchasing a continuous month-to-month subscription which will automatically renew, and that the price of your selected subscription plan level and/or add on(s) will be billed to your designated payment method monthly as a recurring charge, unless you cancel your subscription(s), through your account dashboard,* ***before*** *the beginning of your next monthly billing period.*

***You will be billed for the full monthly period in which you cancel and no refunds will be given. By purchasing a subscription, you agree to a minimum one month purchase obligation.***

Note

For more information on renewal terms and cancellation, refer to the [Terms of Use](https://www.cloudflare.com/terms/).

## Upgrade or downgrade Cloudflare paid plans

If your domain is on a paid plan (for example, Pro) and you upgrade to a higher-priced plan (for example, Business),

* Your invoice will reflect the prorated cost of the higher-tiered plan, until the end of your billing cycle.
* Cloudflare credits the prorated cost of the lower-priced plan, until the end of the billing cycle.
* At the beginning of the next billing cycle, your invoice will reflect the full cost of the higher-priced plan.
* Your bill cycle start and end dates are calculated using the UTC (Coordinated Universal Time) time zone, and not your local time zone.

For example, if your billing date is January 1, but you upgrade from Pro to Business, on January 15,

* Your invoice will reflect the prorated Business plan rate for the period of use January 15 - January 30.
* Cloudflare credits the prorated Pro plan cost from January 1 - January 15.
* Your invoice for the billing period of January 1 - January 30 will appear in the Cloudflare dashboard on January 31.

Note

Account credits are automatically added to your account and can only be used on recurring monthly charges for Cloudflare plans or add-on services. Your monthly invoice lists any credits.

All credits are added on the backend of your account and are not visible from the invoice. The invoice will, however, reflect any uses of applied account credits. Account credits can be used for any future Cloudflare transactions except Registrar transactions.

If your domain is on a paid plan (for example, Business) and you downgrade to a lower-priced plan (for example, Pro),

* Your plan type and higher-tiered Cloudflare plan features are downgraded at the end of the current billing service period.
* You are billed at the lower-tiered plan and feature rate for the next billing service period.

For example, if your billing date is February 1, but you downgrade to Pro from the Business plan on February 15,

* You can access Business plan features and services until March 1.
* Your March plan charges will reflect the downgraded cost.

## Billing and payment for Enterprise plans

Enterprise customers work with the Cloudflare account team to customize a plan and service contract to best suit their needs. The Cloudflare accounting team receives and processes Enterprise plan charges.

Enterprise account owners receive invoices directly from the Cloudflare accounting team.

## Approved payment methods

Cloudflare only accepts Visa, Mastercard, American Express, Discover, PayPal, and UnionPay. No other payment methods (for example, Maestro) are possible at this time.

Note

Enterprise customers can use ACH payments for Cloudflare plans and subscriptions.

Please ensure that you're using a valid payment method before changing your plan type or enabling subscriptions.

Note

Gift cards and pre-payment cards may not be accepted for payment as they are not associated with a billing address.

## Account Payment Method Preauthorization

For services subject to usage-based billing, Cloudflare may preauthorize your credit card at any point in a billing period to confirm the payment method on file can cover accrued fees. This is a temporary hold and you will not be charged until the end of your billing period. If your payment method is validated, service will continue normally.

If your payment method fails, we may suspend your access to the usage-based billing services for which we conducted the preauthorization. In the case of [R2](https://developers.cloudflare.com/r2/), you will not be able to access your R2 buckets and requests will return errors, but your data will remain secure. If you do not update your payment method within 30 days, the data related to any usage-based billing service(s) may be deleted.

To regain access, you must settle any outstanding balances and pass preauthorization with a valid payment method. To update your primary payment method, navigate to the **Manage Account** > **Billing** > **Payment** section of your account. Upon validation of your updated payment details, we will promptly reactivate your subscription(s), which will restore access to the relevant data and services.

For assistance, visit our [Support Portal](https://support.cloudflare.com/hc/en-us) and submit a Billing request (category: “Payment issue”) to our Support team. They will assist you in verifying your updated payment information.

## Non-refundable occurrences

The following occurences cannot be refunded:

* Billing or renewal issues: Often involves charges for renewals, unexpected billing, or issues related to subscription payments.
* Accidental purchases of services and subscriptions: Includes instances where users bought the wrong service, made a mistake during the purchase process, or unintentionally upgraded their plan.
* Domain issues: Incorrect domain registration, issues with domain transfers, or accidental domain purchases.
* Service or plan issues: Issues with a service or plan itself, such as attempts to downgrade, cancel unused services, or problems with specific features.
* Support issues: Unresolved support issues.

## Related resources

* [Cloudflare Self-Serve Subscription Agreement](https://www.cloudflare.com/terms/)
* [Understanding Cloudflare Invoices](https://developers.cloudflare.com/billing/invoices/)
* [Understanding Cloudflare sales tax](https://developers.cloudflare.com/billing/sales-tax/)
