---
title: PCAPs bucket setup · Cloudflare Magic Firewall docs
description: Before you can begin a full packet capture, you must first
  configure a bucket that Cloudflare can use to upload your files. Setting up a
  bucket is not required for sample packet captures.
lastUpdated: 2025-09-09T15:44:21.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/magic-firewall/packet-captures/pcaps-bucket-setup/
  md: https://developers.cloudflare.com/magic-firewall/packet-captures/pcaps-bucket-setup/index.md
---

Before you can begin a full packet capture, you must first configure a bucket that Cloudflare can use to upload your files. Setting up a bucket is not required for sample packet captures.

You can configure an Amazon S3 or Google Cloud Platform bucket to use as a target. You can also [use R2](#r2) as a target using the API.

## Set up a bucket

Learn how to set up a bucket for use with full packet captures.

* Dashboard

  1. In the Cloudflare dashboard, go to the **Packet captures** page in Magic Transit or Magic WAN.

     To set up a bucket in Magic Transit: [Go to **Packet captures**](https://dash.cloudflare.com/?to=/:account/magic-transit/packet-captures/captures)

     To set up a bucket in Magic WAN: [Go to **Packet captures**](https://dash.cloudflare.com/?to=/:account/magic-wan/packet-captures/captures)

  2. Select the **Buckets** tab.

  3. Select **Add a bucket**.

  4. Under **Bucket configuration**, select a bucket service and select **Next**.

  5. Enter the information related to your bucket for your service provider.

  6. When you are done, select **Next**.

  The **Prove ownership** step of the **Bucket configuration** displays.

* API

  Before you can begin using a bucket, you must first enable destinations.

  Refer to the [Amazon S3](https://developers.cloudflare.com/logs/logpush/logpush-job/enable-destinations/aws-s3/#create-and-get-access-to-an-s3-bucket) or [Google Cloud Storage](https://developers.cloudflare.com/logs/logpush/logpush-job/enable-destinations/google-cloud-storage/#create-and-get-access-to-a-gcs-bucket) documentation and follow the steps for those specific services.

Next, validate the bucket and confirm ownership.

## Validate a bucket

After the initial bucket set up, you need to confirm you own the bucket via an ownership challenge. After you validate your bucket, you can begin using it to collect full packet captures.

* Dashboard

  1. From the **Prove ownership** step of the **Bucket configuration**, locate the **Ownership token** field.
  2. In the **Ownership token** field, enter the ownership token for your service provider.
  3. When you are done, select **Create**. The **Packet captures** page displays.

  The **Buckets** tab displays a list of the buckets associated with your account. Refer to the **Status** column to see the status of your bucket configuration.

* API

  The `bucket` field should be the URI of the bucket. For Amazon S3, the `bucket` field is in the form `s3://<bucket-name>/<directory>?region=<bucket-region>`, and for Google Cloud Storage the form is `gs://<bucket-name>/<directory>`.

  ```bash
  curl https://api.cloudflare.com/client/v4/accounts/{account_id}/pcaps/ownership \
  --header "X-Auth-Email: <EMAIL>" \
  --header "X-Auth-Key: <API_KEY>" \
  --header "Content-Type: application/json" \
  --data '{
    "destination_conf": "'${bucket}'"
  }'
  ```

  The response has a `"filename"` parameter which contains the content of the `ownership-challenge` text. Find the file in your bucket and copy the contents of the file.

  ```json
  {
    "result": {
      "id": "cc20c2d6c62e11ecbe646b173af3b6b9",
      "status": "pending",
      "submitted": "2022-04-22T18:54:13.397413Z",
      "validated": "",
      "destination_conf": "gs://bucket-test", // Ensure you use a bucket that you created and registered in the Cloudflare dashboard.
      "filename": "ownership-challenge-1234.txt"
    },
    "success": true,
    "errors": [],
    "messages": []
  }
  ```

  Validate the bucket by inserting the copied text in the `ownership_text` below:

  ```bash
  curl https://api.cloudflare.com/client/v4/accounts/{account_id}/pcaps/ownership/validate \
  --header "X-Auth-Email: <EMAIL>" \
  --header "X-Auth-Key: <API_KEY>" \
  --header "Content-Type: application/json" \
  --data '{
    "destination_conf": "'${bucket}'",
    "ownership_challenge": "'${ownership_text}'"
  }'
  ```

  ```json
  {
    "result": {
      "id": "cc20c2d6c62e11ecbe646b173af3b6b9",
      "status": "success",
      "submitted": "2022-04-22T18:54:13.397413Z",
      "validated": "2022-04-27T14:54:46.440548Z",
      "destination_conf": "gs://<bucket-name>", // Ensure you use a bucket that you created and registered in the Cloudflare dashboard
      "filename": "ownership-challenge-1234.txt"
    },
    "success": true,
    "errors": [],
    "messages": []
  }
  ```

  If the `status` shows `success`, the bucket is configured and ready to use.

The bucket status displays one of the following options:

* **Success:** The bucket is fully verified and ready to use.
* **Pending:** The challenge response was initiated but is pending verification. Bucket verification can take five to ten minutes to finish processing.
* **Failed:** The bucket could not be validated. If this occurs, verify your ownership information.

## List configured buckets

View a list of all buckets configured on your account.

* Dashboard

  1. In the Cloudflare dashboard, go to the **Packet captures** page in Magic Transit or Magic WAN.

     To set up a packet capture in Magic Transit: [Go to **Packet captures**](https://dash.cloudflare.com/?to=/:account/magic-transit/packet-captures/captures)

     To set up a packet capture in Magic WAN: [Go to **Packet captures**](https://dash.cloudflare.com/?to=/:account/magic-wan/packet-captures/captures)

  2. In **Packet captures**, select **Start a capture**.

  3. Select the **Buckets** tab.

  The list of buckets associated with your account displays.

* API

  ```bash
  curl https://api.cloudflare.com/client/v4/accounts/{account_id}/pcaps/ownership \
  --header "X-Auth-Email: <EMAIL>" \
  --header "X-Auth-Key: <API_KEY>"
  ```

  ```json
  {
    "result": [
      {
        "id": "9a993aa6c58711ec89d3037647342e63",
        "status": "success",
        "submitted": "2022-04-26T16:58:24.550762Z",
        "validated": "2022-04-26T17:01:18.426458Z",
        "destination_conf": "s3://test-bucket?region=us-east-1",
        "filename": "ownership-challenge-1234.txt"
      }
    ],
    "success": true,
    "errors": [],
    "messages": []
  }
  ```

To learn how to collect packet captures, refer to [Collect packet captures](https://developers.cloudflare.com/magic-firewall/packet-captures/collect-pcaps/).

## R2

To start collecting packet captures with R2, you first need to configure it properly. For all the required details, refer to the [Cloudflare R2](https://developers.cloudflare.com/r2/) documentation.

### Create bucket and API token

1. In the Cloudflare dashboard, go to the **R2** page.

   [Go to **Overview**](https://dash.cloudflare.com/?to=/:account/r2/overview)

2. Select **Create bucket**.

3. Give your bucket a name > **Create bucket**.

4. Go to the R2 Overview page, and select **Manage R2 API Tokens**.

5. Select **Create API Token**.

6. In **Permissions**, choose **Object Read & Write**. Make sure you also select **Apply to specific buckets only**, and select the bucket you have created for PCAPs from the drop-down menu.

7. Select **Create API Token**.

8. Make sure you copy the **Secret Access Key** and **Access Key ID** values, as you will need them for the next step.

### Create initial request

Create your initial request to R2:

```bash
curl https://api.cloudflare.com/client/v4/accounts/{account_id}/pcaps/ownership \
--header "X-Auth-Email: <EMAIL>" \
--header "X-Auth-Key: <API_KEY>" \
--header "Content-Type: application/json" \
--data '{
  "destination_conf": "r2://<BUCKET_NAME>?account-id=<ACCOUNT_ID>&access-key-id=<R2_ACCESS_KEY_ID>&secret-access-key=<R2_SECRET_ACCESS_KEY>"
}'
```

The [response](https://developers.cloudflare.com/api/resources/magic_transit/subresources/pcaps/subresources/ownership/methods/create/) has a `"filename"` parameter with the name of a file that Cloudflare wrote to your R2 bucket. You need to download it for the next step. Example:

```json
{
  "errors": [],
  "messages": [],
  "result": {
    "destination_conf": "<YOUR_R2_BUCKET>",
    "filename": "ownership-challenge-9883874ecac311ec8475433579a6bf5f.txt",
    "id": "9883874ecac311ec8475433579a6bf5f",
    "status": "success",
    "submitted": "2020-01-01T08:00:00Z",
    "validated": "2020-01-01T08:00:00Z"
  },
  "success": true
}
```

### Validate bucket ownership

Refer to the [Validate a bucket](#validate-a-bucket) API instructions for more details on the entire process to [validate your R2 bucket](https://developers.cloudflare.com/api/resources/magic_transit/subresources/pcaps/subresources/ownership/methods/validate/). When specifying the R2 destination for this validation, exclude the secret and access keys from the URL.
