---
title: Route /images to an S3 Bucket using Terraform · Cloudflare Rules docs
description: Route requests with a URI path starting with `/images` to a
  specific AWS S3 bucket with Cloud Connector using Terraform.
lastUpdated: 2025-10-13T13:40:40.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/rules/cloud-connector/examples/route-images-to-aws-s3-using-terraform/
  md: https://developers.cloudflare.com/rules/cloud-connector/examples/route-images-to-aws-s3-using-terraform/index.md
---

Note

Terraform code snippets below refer to the v4 SDK only.

The following example defines a single Cloud Connector rule for a zone using Terraform. The rule routes requests to `/images` on your domain to an AWS S3 bucket.

```tf
resource "cloudflare_cloud_connector_rules" "serve_images_in_aws" {
  zone_id = "<ZONE_ID>"
  rules {
    description = "Route images to AWS S3 bucket"
    enabled     = true
    expression  = "http.request.full_uri wildcard \"https://<YOUR_HOSTNAME>/images/*\""
    provider    = "aws_s3"
    parameters {
      host = "<BUCKET_NAME>.s3.amazonaws.com"
    }
  }
}
```

## Additional resources

For additional guidance on using Terraform with Cloudflare, refer to the following resources:

* [Terraform documentation](https://developers.cloudflare.com/terraform/)
* [Cloudflare Provider for Terraform](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs) (reference documentation)
